/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.registry.RegistryUtil;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2405;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import org.jetbrains.annotations.ApiStatus;

public abstract class ResourceGenerator {
    public static class_7225.class_7874 registryAccess;
    protected final String modid;
    protected final String modName;
    protected final ResourceCache cache;

    public static class_2405 createDataProvider(ResourceGenerator generator) {
        return new DataProviderInstance(generator);
    }

    public ResourceGenerator(String modid, ResourceCache cache) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        Optional modContainer = FabricLoader.getInstance().getModContainer(modid);
        if (modid.equals("minecraft")) {
            CoreLib.LOGGER.warn("Mod is creating a resource generator with modid '" + modid + "'!");
        } else if (modContainer.isEmpty()) {
            CoreLib.LOGGER.warn("Mod is creating a resource generator for unknown modid '" + modid + "'!");
        }
        this.modid = modid;
        this.cache = cache;
        this.modName = modContainer.map(ModContainer::getMetadata).map(ModMetadata::getName).orElse(modid);
    }

    public abstract void generate();

    public abstract void save();

    public String getName() {
        return this.modName + " Resource Generator";
    }

    public final String getOwnerModid() {
        return this.modid;
    }

    @ApiStatus.Internal
    public static class DataProviderInstance
    implements class_2405 {
        private final ResourceGenerator generator;
        private boolean generated = false;

        public DataProviderInstance(ResourceGenerator generator) {
            this.generator = generator;
        }

        public void generate() {
            this.generated = true;
            this.generator.generate();
        }

        public CompletableFuture<?> method_10319(class_7403 output) {
            if (!this.generated) {
                this.generator.generate();
            }
            this.generator.save();
            return CompletableFuture.allOf(new CompletableFuture[0]);
        }

        public String method_10321() {
            return this.generator.getName();
        }
    }
}

